# FILE: LandMassesBonuses.py
# PURPOSE: A script for using LandMasses's bonuses generation.
# VERSION 1.0

# Import the required files.

import operator
from CvPythonExtensions import *
import CvUtil
import CvMapGeneratorUtil
from CvMapGeneratorUtil import FractalWorld
from CvMapGeneratorUtil import TerrainGenerator
from CvMapGeneratorUtil import FeatureGenerator
import pickle
import math

#--------------------------------------------------------------------------------------------------------------------------#
# CUSTOMISING RESOURCE PLACEMENT
#--------------------------------------------------------------------------------------------------------------------------#

# Note the UNMODDED value of each resource.
#  0 - Aluminium
#  1 - Coal
#  2 - Copper
#  3 - Horse
#  4 - Iron
#  5 - Marble
#  6 - Oil
#  7 - Stone
#  8 - Uranium
#  9 - Banana
# 10 - Clam
# 11 - Corn
# 12 - Cow
# 13 - Crab
# 14 - Deer
# 15 - Fish
# 16 - Pig
# 17 - Rice
# 18 - Sheep
# 19 - Wheat
# 20 - Dye
# 21 - Fur
# 22 - Gems
# 23 - Gold
# 24 - Incense
# 25 - Ivory
# 26 - Silk
# 27 - Silver
# 28 - Spices
# 29 - Sugar
# 30 - Wine
# 31 - Whale

# CUSTOMISING 'RESOURCE LANDMASSES' OPTION
# Editing here will alter which resources are restricted to individual land masses by the option 'Custom' under the custom
# game setup menu option 'Resource LandMasses:'. Left unedited, this option will give the same results as 'LandMasses'.

# Isolated contains the list of resources which are restricted to a single continent.

def CustomiseResourceLandMasses():
        
        Isolated = [11, 12, 16, 17, 18, 19, 25, 26, 29, 30]
        
        return Isolated

# CUSTOMISING 'HOW MANY LAND MASSES' OPTION
# Editing here will alter how many land masses each resource is assigned to by the option "Custom" under the custom game
# setup menu option 'How Many Land Masses?'. Left unedited, this option will assign isolated resources to just one land
# mass. Resources are listed in the above order, starting with the 0th resource, aluminium, and ending with the 31st
# resource, whale.
# Values can be -2, -1, 0, or from 1 to 9, or some variant of LandMassNumber.
# -2 assigns a resource to all but one of the land masses.
# -1 assigns a resource to half of the land masses.
# 0 assigns a resource to all land masses.
# 1 to 9 assigns a resource to that many land masses, assuming that many exist.
# A number less than -2, greater than 9 or greater than the number of landmasses is treated as a 0.
# LandMassNumber is the number of different land masses generated by the game. This may be different from the number of
# land masses selected in the custom game setup menu. Setting a resource to 'LandMassNumber - 2' would place a resource
# on all land masses but two, unless there are two land masses or less, in which case the resource is placed on all land
# masses. Note that Python is case sensitive. You must place the capital letters correctly to make use of LandMassNumber.

def CustomisingHowManyLandMasses(LandMassNumber):

        Isolations = [1, 1, 1, 1, 1, 1, 1, 1, 1,          # Strategic Resources.
                      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,    # Health Resources.
                      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1] # Luxury Resources.

        return Isolations

# CUSTOMISING 'RESOURCE TILES' OPTION
# Editing here will alter where resources will be placed by the option 'Custom' under the custom game setup menu
# option 'Resource Tiles:'. Left unedited, this option will give the same results as 'LandMasses'.

# AllLand contains the resources that can be found on any land tile. A resource placed in AllLand should not be placed in
# any other list relating to land tiles.
# AllWater contains the resources that can be found on any salt water tile (within reach of a coastal city's fat cross). A
# resource placed in AllWater should not be placed in any other list relating to water tiles.
# Coast contains the resources that can be found in coastal waters.
# Ocean contains the resources that can be found in ocean waters.
# Snow lists the resources that can be found on flat snow.
# HillSnow lists the resources that can be found on snow hills.
# Tundra lists the resources that can be found on flat tundra.
# ForestTundra lists the resources that can be found on flat forested tundra.
# HillTundra lists the resources that can be found on tundra hills.
# HillForestTundra lists the resources that can be found on forested tundra hills.
# And so on.

def CustomiseResourceTiles():
        
        AllLand = [0, 1, 2, 4, 5, 6, 7, 8, 22, 23, 24, 27]
        AllWater = [6, 10, 13, 15, 31]
        Coast = []
        Ocean = []
        Snow = [21]
        HillSnow = [21]
        Tundra = [14, 18, 21, 25]
        ForestTundra = [14, 21, 25]
        HillTundra = [14, 18, 21]
        HillForestTundra = [14, 21]
        FloodPlainTundra = []
        Grass = [3, 11, 12, 16, 17, 18, 19, 20, 25, 28, 29, 30]
        ForestGrass = [9, 16, 20, 25, 26, 28, 29, 30]
        JungleGrass = [9, 16, 20, 25, 26, 28, 29, 30]
        HillGrass = [16, 18, 20, 28, 30]
        HillForestGrass = [9, 16, 20, 26, 28, 29, 30]
        HillJungleGrass = [9, 16, 20, 26, 28, 29, 30]
        FloodPlainGrass = []
        Plain = [3, 11, 12, 14, 16, 17, 18, 19, 20, 21, 25, 28, 29, 30]
        ForestPlain = [9, 14, 16, 20, 21, 25, 26, 28, 29, 30]
        HillPlain = [14, 16, 18, 20, 21, 28, 30]
        HillForestPlain = [9, 14, 16, 20, 21, 26, 28, 29, 30]
        FloodPlainPlain = []
        Desert = []
        HillDesert = []
        FloodPlainDesert = []

        return (AllLand, AllWater, Coast, Ocean, Snow, HillSnow, Tundra, ForestTundra, HillTundra, HillForestTundra,
                FloodPlainTundra, Grass, ForestGrass, JungleGrass, HillGrass, HillForestGrass, HillJungleGrass,
                FloodPlainGrass, Plain, ForestPlain, HillPlain, HillForestPlain, FloodPlainPlain, Desert, HillDesert,
                FloodPlainDesert)

# CUSTOMISING RESOURCE QUANTITIES (STRATEGIC, HEALTH, AND LUXURY) OPTIONS
# ResourceQuantities lists the number of each resource to be placed. Resources are listed in the above order, starting
# with the 0th resource, aluminium, and ending with the 31st resource, whale.
# Unedited, selecting 'custom' from any of the resource quantity options will set such resources to 'normal'.
# Values can be -4, -3, -2, -1, 0, or greater.
# 0 or greater produces that amount of the appropriate resource.
# Setting a resource to -1 will produce few of that resource as defined by the resource quantity options 'few'.
# Setting a resource to -2 will produce a normal amount of it as defined by the resource quantity options 'normal'.
# Setting a resource to -3 will produce many of that resource as defined by the resource quantity options 'many'.
# Setting a resource to -4 will produce one resource per civilization.
# If a resource is set to -5 or less it will be treated as -2.

def CustomiseResourceQuantities():
        
        ResourceQuantities = [-2, -2, -2, -2, -2, -2, -2, -2, -2,             # StrategicResources.
                              -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,     # Health Resources.
                              -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2] # Luxury resources.

        return ResourceQuantities

# CUSTOMISING 'LET RESOURCES CLUMP' OPTION
# ResourceClumps lists whether or not each resource may be clumped. Resources are listed in the above order, starting
# with the 0th resource, aluminium, and ending with the 31st resource, whale.
# Unedited, selecting 'custom' from any of the resource quantity options will set such resources to 'standard'.
# Values can be 0 (resource will not be clumped) or 1 (resource may be clumped).
# If a resource is set to any other value it will be treated as 1.

def CustomiseResourceClumps():

        ResourceClumps = [0, 0, 0, 0, 0, 0, 0, 0, 0,          # Strategic Resources.
                          0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    # Health Resources.
                          1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1] # Luxury Resources.

        return ResourceClumps

#--------------------------------------------------------------------------------------------------------------------------#
# Predefined variables.
#--------------------------------------------------------------------------------------------------------------------------#

cachedMenuChoices = []
isamodule = False
width = 0
Area = 0
cardinalDirs = [(-1,0),(0,-1),(0,1),(1,0)]
PlayerStartCross = [(-1,-1),(-1,0),(-1,1),(0,-1),(0,1),(1,-1),(1,0),(1,1),
                    (-2,-1),(-2,0),(-2,1),(2,-1),(2,0),(2,1),(-1,2),(0,2),(1,2),(-1,-2),(0,-2),(1,-2)]
PreventResourceClumping = [(-1,4),(0,4),(1,4),(4,1),(4,0),(4,-1),(-1,-4),(0,-4),(1,-4),(-4,1),(-4,0),(-4,-1),
                           (2,3),(1,3),(0,3),(-1,3),(-2,3),(-3,2),(-3,1),(-3,0),(-3,-1),(-3,-2),(-2,-3),(-1,-3),(0,-3),
                           (1,-3),(2,-3),(3,-2),(3,-1),(3,0),(3,1),(3,2),
                           (2,2),(1,2),(0,2),(-1,2),(-2,2),(-2,1),(-2,0),(-2,-1),(-2,-2),(-1,-2),(0,-2),(1,-2),(2,-2),
                           (2,-1),(2,0),(2,1),
                           (1,1),(0,1),(-1,1),(-1,0),(-1,-1),(0,-1),(1,-1),(1,0)]

#--------------------------------------------------------------------------------------------------------------------------#
# Step 1: Place bonuses.
#--------------------------------------------------------------------------------------------------------------------------#

def addBonuses(module = False):

        global isamodule

        if not module:
                isamodule = False
        elif module:
                isamodule = True
        
        cymap = CyMap()
	gc = CyGlobalContext()
	dice = gc.getGame().getMapRand()
	saveSettings()

	# Determine which options have been selected.

	if isamodule:
                settings = open('LandMasses Bonuses.cfg', 'r')
                SavedSettings = pickle.load(settings)
                Settings = []
                for Option in range(len(selection_names_and_values)):
                        for Choice in range(len(selection_names_and_values[Option])):
                                if SavedSettings[Option][1] == selection_names_and_values[Option][Choice][0]:
                                        Settings.append(selection_names_and_values[Option][Choice][1])
                                        break
                [ResourceRegion, ResourceIsolations, ResourceTiles, StrategicQuantity, HealthQuantity,
                 LuxuryQuantity, ResourceClumps] = Settings
        elif not isamodule:
                ResourceRegion = getSelectedMapValue("Resource Land Masses:")
                ResourceIsolations = getSelectedMapValue("How Many Land Masses:")
                ResourceTiles = getSelectedMapValue("Resource Tiles:")
                StrategicQuantity = getSelectedMapValue("Strategic Supply:")
                HealthQuantity = getSelectedMapValue("Health Supply:")
                LuxuryQuantity = getSelectedMapValue("Luxury Supply:")
                ResourceClumps = getSelectedMapValue("Let Resources Clump:")

        global Area
	global width
	
	width = cymap.getGridWidth()
	height = cymap.getGridHeight()
	Area = width*height

	# Determine the actual number of land masses generated.

	LandMasses = GetLandMasses()

	# If 'Random' has been selected for any options.

	if ResourceRegion < 0:
                ResourceRegion = dice.get(4, "Standard, LandMasses, LandMasses - isolate horses, or no isolated resources.")

        if ResourceIsolations == 0:
                ResourceIsolations = 1 + dice.get((len(LandMasses) - 1), "between 1 and (LandMasses - 1).")

        if StrategicQuantity != -5 and HealthQuantity != -5 and LuxuryQuantity != -5:

                if StrategicQuantity == 0:
                        StrategicQuantity = 1 + dice.get(3, "Less, normal, or more strategic quantities.")
                        if StrategicQuantity == 1:
                                StrategicQuantity = -1
                        if StrategicQuantity == 2:
                                StrategicQuantity = -2
                        if StrategicQuantity == 3:
                                StrategicQuantity = -3

                if HealthQuantity == 0:
                        HealthQuantity = 1 + dice.get(3, "Less, normal, or more health quantity")
                        if HealthQuantity == 1:
                                HealthQuantity = -1
                        if HealthQuantity == 2:
                                HealthQuantity = -2
                        if HealthQuantity == 3:
                                HealthQuantity = -3

                if LuxuryQuantity == 0:
                        LuxuryQuantity = 1 + dice.get(3, "Less, normal, or more luxury quantity")
                        if LuxuryQuantity == 1:
                                LuxuryQuantity = -1
                        if LuxuryQuantity == 2:
                                LuxuryQuantity = -2
                        if LuxuryQuantity == 3:
                                LuxuryQuantity = -3
        
	Players = gc.getGame().countCivPlayersEverAlive()
	FeatureOasis = gc.getInfoTypeForString("FEATURE_OASIS")
	FeatureIce = gc.getInfoTypeForString("FEATURE_ICE")

	if ResourceTiles == 1:

                TerrainGrass = gc.getInfoTypeForString("TERRAIN_GRASS")
                TerrainPlain = gc.getInfoTypeForString("TERRAIN_PLAINS")
                TerrainDesert = gc.getInfoTypeForString("TERRAIN_DESERT")
                TerrainTundra = gc.getInfoTypeForString("TERRAIN_TUNDRA")
                TerrainSnow = gc.getInfoTypeForString("TERRAIN_SNOW")
                FeatureForest = gc.getInfoTypeForString("FEATURE_FOREST")
                FeatureJungle = gc.getInfoTypeForString("FEATURE_JUNGLE")
                FeatureFloodPlain = gc.getInfoTypeForString("FEATURE_FLOOD_PLAINS")

                # AllLand contains the resources that can go on all land tiles.
                # AllWater contains the resources that can go on all water tiles.
                # Each other list contains the resources that can go on the specific tile type listed.

                AllLand = [0, 1, 2, 4, 5, 6, 7, 8, 22, 23, 24, 27]
                AllWater = [6, 10, 13, 15, 31]
                Snow = [21]
                HillSnow = [21]
                Tundra = [14, 18, 21, 25]
                ForestTundra = [14, 21, 25]
                HillTundra = [14, 18, 21]
                HillForestTundra = [14, 21]
                FloodPlainTundra = []
                Grass = [3, 11, 12, 16, 17, 18, 19, 20, 25, 28, 29, 30]
                ForestGrass = [9, 16, 20, 25, 26, 28, 29, 30]
                JungleGrass = [9, 16, 20, 25, 26, 28, 29, 30]
                HillGrass = [16, 18, 20, 28, 30]
                HillForestGrass = [9, 16, 20, 26, 28, 29, 30]
                HillJungleGrass = [9, 16, 20, 26, 28, 29, 30]
                FloodPlainGrass = []
                Plain = [3, 11, 12, 14, 16, 17, 18, 19, 20, 21, 25, 28, 29, 30]
                ForestPlain = [9, 14, 16, 20, 21, 25, 26, 28, 29, 30]
                HillPlain = [14, 16, 18, 20, 21, 28, 30]
                HillForestPlain = [9, 14, 16, 20, 21, 26, 28, 29, 30]
                FloodPlainPlain = []
                Desert = []
                HillDesert = []
                FloodPlainDesert = []

	elif ResourceTiles == 3:

                TerrainGrass = gc.getInfoTypeForString("TERRAIN_GRASS")
                TerrainPlain = gc.getInfoTypeForString("TERRAIN_PLAINS")
                TerrainDesert = gc.getInfoTypeForString("TERRAIN_DESERT")
                TerrainTundra = gc.getInfoTypeForString("TERRAIN_TUNDRA")
                TerrainSnow = gc.getInfoTypeForString("TERRAIN_SNOW")
                TerrainCoast = gc.getInfoTypeForString("TERRAIN_COAST")
                TerrainOcean = gc.getInfoTypeForString("TERRAIN_OCEAN")
                FeatureForest = gc.getInfoTypeForString("FEATURE_FOREST")
                FeatureJungle = gc.getInfoTypeForString("FEATURE_JUNGLE")
                FeatureFloodPlain = gc.getInfoTypeForString("FEATURE_FLOOD_PLAINS")

                (AllLand, AllWater, Coast, Ocean, Snow, HillSnow, Tundra, ForestTundra, HillTundra, HillForestTundra,
                 FloodPlainTundra, Grass, ForestGrass, JungleGrass, HillGrass, HillForestGrass, HillJungleGrass,
                 FloodPlainGrass, Plain, ForestPlain, HillPlain, HillForestPlain, FloodPlainPlain, Desert, HillDesert,
                 FloodPlainDesert) = CustomiseResourceTiles()

        else:

                # AllLand contains the resources that can go on all land tiles.
                # AllWater contains the resources that can go on all water tiles.

                AllLand = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30]
                AllWater = [6, 10, 13, 15, 31]

	# Isolated lists the resources that are unique to their respective landmasses.

	if ResourceRegion == 0:
                Isolated = [9, 11, 12, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30]
        elif ResourceRegion == 1:
                Isolated = [11, 12, 16, 17, 18, 19, 25, 26, 29, 30]
        elif ResourceRegion == 2:
                Isolated = [3, 11, 12, 16, 17, 18, 19, 25, 26, 29, 30]
        elif ResourceRegion == 4:
                Isolated = CustomiseResourceLandMasses()

        # Determine how many land masses each resource is placed on.

        if ResourceIsolations > 0 and ResourceIsolations < len(LandMasses):
                Isolations = [ResourceIsolations]*32
        elif ResourceIsolations == -1 and len(LandMasses) > 1:
                Isolations = [len(LandMasses)/2]*32
        elif ResourceIsolations == -2 and len(LandMasses) > 1:
                Isolations = [len(LandMasses) - 1]*32
        elif ResourceIsolations == -3:
                Isolations = CustomisingHowManyLandMasses(len(LandMasses))
                for Resource in range(len(Isolations)):
                        if Isolations[Resource] > len(LandMasses):
                                Isolations[Resource] = len(LandMasses)
                        elif Isolations[Resource] == -1:
                                Isolations[Resource] = len(LandMasses)/2
                        elif Isolations[Resource] == -2:
                                Isolations[Resource] = len(LandMasses) - 1
                        elif Isolations[Resource] < -2:
                                Isolations[Resource] = len(LandMasses)
                        if Isolations[Resource] == 0:
                                Isolations[Resource] = len(LandMasses)
        else:
                ResourceRegion = 3

        # Set up the list containing the land masses each resource is assigned to.

        if ResourceRegion != 3:
                ResourceLM = []
                for Resource in range(32):
                        if Resource in Isolated and Isolations[Resource] > 0 and Isolations[Resource] < len(LandMasses):
                                ResourceLM.append([-1]*(Isolations[Resource]))
                        else:
                                ResourceLM.append(-1)
        else:
                ResourceLM = [-1]*(32)

        # Determine which land masses each resource is assigned to.

        if ResourceRegion != 3:
                for Resource in Isolated:
                        for LandMass in range(len(ResourceLM[Resource])):
                                while ResourceLM[Resource][LandMass] == -1:
                                        I = dice.get(Area, "Pick a tile.")
                                        for i in range(len(LandMasses)):
                                                if I in LandMasses[i]:
                                                        if i not in ResourceLM[Resource]:
                                                                ResourceLM[Resource][LandMass] = i
                                                        break
	
	# Determine all possible locations for each bonus.
	
	EligibleTiles = []
	
	for Resource in range(32):
		EligibleTiles.append([])
	
	for I in range(Area):

                Plot = cymap.plotByIndex(I)
                PlotType = Plot.getPlotType()
                Terrain = Plot.getTerrainType()
                Feature = Plot.getFeatureType()

                # No resources are placed on peaks.

                if PlotType == PlotTypes.PLOT_PEAK:
                        continue

                # No resources placed under ice or on an oasis.

                if Feature == FeatureIce or Feature == FeatureOasis:
                        continue

                # Is the tile a part of any land mass?

                for i in range(len(LandMasses)):
                        if I in LandMasses[i]:
                                LandMass = i
                                break

                # Determine appropriate tiles for aquatic resources.

                if Plot.isWater():

                        # If the tile is not too far from flat land or a hill it can contain aquatic resources.
                        
                        for i in PlayerStartCross:
                                Inew = GetNewTileIndex(I, i)
                                if Inew == -1:
                                        continue
                                if PlotType == PlotTypes.PLOT_LAND or PlotType == PlotTypes.PLOT_HILLS:
                                        for Resource in AllWater:
                                                if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                        if ResourceTiles != 0:
                                                                EligibleTiles[Resource].append(I)
                                                        elif ResourceTiles == 0:
                                                                if Plot.canHaveBonus(Resource, True):
                                                                        EligibleTiles[Resource].append(I)
                                        if ResourceTiles == 3:
                                                if Terrain == TerrainCoast:
                                                        for Resource in Coast:
                                                                if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                        EligibleTiles[Resource].append(I)
                                                elif Terrain == TerrainOcean:
                                                        for Resource in Ocean:
                                                                if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                        EligibleTiles[Resource].append(I)
                                        break

                        continue

                # Determine which tiles are suitable for land resources.

                for Resource in AllLand:
                        
                        if ResourceLM[Resource] != -1 and LandMass not in ResourceLM[Resource]:
                                continue

                        if ResourceTiles != 0:
                                EligibleTiles[Resource].append(I)
                        elif ResourceTiles == 0:
                                if Plot.canHaveBonus(Resource, True):
                                        EligibleTiles[Resource].append(I)

                if ResourceTiles == 1 or ResourceTiles == 3:

                        if Terrain == TerrainSnow:
                                if PlotType == PlotTypes.PLOT_HILLS:
                                        for Resource in HillSnow:
                                                if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                        EligibleTiles[Resource].append(I)
                                elif PlotType == PlotTypes.PLOT_LAND:
                                        for Resource in Snow:
                                                if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                        EligibleTiles[Resource].append(I)

                        elif Terrain == TerrainTundra:
                                if PlotType == PlotTypes.PLOT_HILLS:
                                        if Feature == FeatureForest:
                                                for Resource in HillForestTundra:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)
                                        else:
                                                for Resource in HillTundra:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)
                                elif PlotType == PlotTypes.PLOT_LAND:
                                        if Feature == FeatureForest:
                                                for Resource in ForestTundra:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)
                                        elif Feature == FeatureFloodPlain:
                                                for Resource in FloodPlainTundra:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)
                                        else:
                                                for Resource in Tundra:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)

                        elif Terrain == TerrainGrass:
                                if PlotType == PlotTypes.PLOT_HILLS:
                                        if Feature == FeatureForest:
                                                for Resource in HillForestGrass:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)
                                        elif Feature == FeatureJungle:
                                                for Resource in HillJungleGrass:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)
                                        else:
                                                for Resource in HillGrass:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)
                                elif PlotType == PlotTypes.PLOT_LAND:
                                        if Feature == FeatureForest:
                                                for Resource in ForestGrass:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)
                                        elif Feature == FeatureJungle:
                                                for Resource in JungleGrass:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)
                                        elif Feature == FeatureFloodPlain:
                                                for Resource in FloodPlainGrass:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)
                                        else:
                                                for Resource in Grass:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)

                        elif Terrain == TerrainPlain:
                                if PlotType == PlotTypes.PLOT_HILLS:
                                        if Feature == FeatureForest:
                                                for Resource in HillForestPlain:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)
                                        else:
                                                for Resource in HillPlain:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)
                                elif PlotType == PlotTypes.PLOT_LAND:
                                        if Feature == FeatureForest:
                                                for Resource in ForestPlain:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)
                                        elif Feature == FeatureFloodPlain:
                                                for Resource in FloodPlainPlain:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)
                                        else:
                                                for Resource in Plain:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)

                        elif Terrain == TerrainDesert:
                                if PlotType == PlotTypes.PLOT_HILLS:
                                        for Resource in HillDesert:
                                                if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                        EligibleTiles[Resource].append(I)
                                if PlotType == PlotTypes.PLOT_LAND:
                                        if Feature == FeatureFloodPlain:
                                                for Resource in FloodPlainDesert:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)
                                        else:
                                                for Resource in Desert:
                                                        if ResourceLM[Resource] == -1 or LandMass in ResourceLM[Resource]:
                                                                EligibleTiles[Resource].append(I)

        # Prepare to place the resources.

        ResourcesOrder = []
        ResourceLocations = []

        if StrategicQuantity == -5 or HealthQuantity == -5 or LuxuryQuantity == -5:
                ResourceQuantities = CustomiseResourceQuantities()
        
	for Resource in range(gc.getNumBonusInfos()):
		ResourceInfoXML = gc.getBonusInfo(Resource)
		if ResourceInfoXML.getPlacementOrder() >= 0:
			ResourcesOrder.append((Resource,ResourceInfoXML.getPlacementOrder()))

	ResourcesOrder = sorted(ResourcesOrder, key = operator.itemgetter(1))
	
	for ResourceOrder in ResourcesOrder:

                added = 0
                tries = 0
                NearLocations = []
                Resource, Order = ResourceOrder
                ResourceInfoXML = gc.getBonusInfo(Resource)

                # If modded resources are to be placed, LandMasses tries to place them in the standard way.

                if Resource >= 35:
			addBonusType([Resource])

		# Determine how much of the resource is to be placed.

		if Resource < 9:
                        if StrategicQuantity == -5:
                                ResourceCount = ResourceQuantities[Resource]
                                if ResourceCount <= -5:
                                        ResourceCount = -2
                                elif ResourceCount == -4:
                                        ResourceCount == Players
                                elif ResourceCount == -1:
                                        ResourceCount = (Players + 1)/2 + dice.get(Players/2, "How many of the resource?")
                                        ResourceCount = ResourceCount/2
                                elif ResourceCount == -2:
                                        ResourceCount = (Players + 1)/2 + dice.get(Players/2, "How many of the resource?")
                                elif ResourceCount == -3:
                                        ResourceCount = (Players + 1)/2 + dice.get(Players/2, "How many of the resource?")
                                        ResourceCount = ResourceCount*2
                        elif StrategicQuantity == -4:
                                ResourceCount = Players
                        elif StrategicQuantity > -4:
                                ResourceCount = (Players + 1)/2 + dice.get(Players/2, "How many of the resource?")
                                if StrategicQuantity == -1:
                                        ResourceCount = ResourceCount/2
                                elif StrategicQuantity == -3:
                                        ResourceCount = ResourceCount*2
                elif Resource < 20:
                        if HealthQuantity == -5:
                                ResourceCount = ResourceQuantities[Resource]
                                if ResourceCount <= -5:
                                        ResourceCount = -2
                                elif ResourceCount == -4:
                                        ResourceCount == Players
                                elif ResourceCount == -1:
                                        ResourceCount = (Players + 1)/2 + dice.get(Players/2, "How many of the resource?")
                                        ResourceCount = ResourceCount/2
                                elif ResourceCount == -2:
                                        ResourceCount = (Players + 1)/2 + dice.get(Players/2, "How many of the resource?")
                                elif ResourceCount == -3:
                                        ResourceCount = (Players + 1)/2 + dice.get(Players/2, "How many of the resource?")
                                        ResourceCount = ResourceCount*2
                        elif HealthQuantity == -4:
                                ResourceCount = Players
                        elif HealthQuantity > -4:
                                ResourceCount = (Players + 1)/2 + dice.get(Players/2, "How many of the resource?")
                                if HealthQuantity == -1:
                                        ResourceCount = ResourceCount/2
                                elif HealthQuantity == -3:
                                        ResourceCount = ResourceCount*2
                elif Resource < 32:
                        if LuxuryQuantity == -5:
                                ResourceCount = ResourceQuantities[Resource]
                                if ResourceCount <= -5:
                                        ResourceCount = -2
                                elif ResourceCount == -4:
                                        ResourceCount == Players
                                elif ResourceCount == -1:
                                        ResourceCount = (Players + 1)/2 + dice.get(Players/2, "How many of the resource?")
                                        ResourceCount = ResourceCount/2
                                elif ResourceCount == -2:
                                        ResourceCount = (Players + 1)/2 + dice.get(Players/2, "How many of the resource?")
                                elif ResourceCount == -3:
                                        ResourceCount = (Players + 1)/2 + dice.get(Players/2, "How many of the resource?")
                                        ResourceCount = ResourceCount*2
                        elif LuxuryQuantity == -4:
                                ResourceCount = Players
                        elif LuxuryQuantity > -4:
                                ResourceCount = (Players + 1)/2 + dice.get(Players/2, "How many of the resource?")
                                if LuxuryQuantity == -1:
                                        ResourceCount = ResourceCount/2
                                elif LuxuryQuantity == -3:
                                        ResourceCount = ResourceCount*2

		# Remove eligible tiles that already contain a resource.

		for I in ResourceLocations:
                        if I in EligibleTiles[Resource]:
                                EligibleTiles[Resource].remove(I)

		# Place the resource.
		
		while (added < ResourceCount and tries < 4*ResourceCount):

                        tries += 1

			# Are there any available plots for the resource?
			
			if EligibleTiles[Resource] == []:
				break

			# Pick an eligible tile.

			EligibleTile = dice.get(len(EligibleTiles[Resource]), "A random eligible tile.")
			I = EligibleTiles[Resource][EligibleTile]
			del EligibleTiles[Resource][EligibleTile]

			NearResource = 1
			NearResources = 1

			for i in PlayerStartCross:
                                Inew = GetNewTileIndex(I, i)
                                if Inew == -1:
                                        continue
                                if Inew in NearLocations:
                                        NearResource += 1
                                if Inew in ResourceLocations:
                                        NearResources += 1

                        RandOne = 1 + dice.get(NearResource, "Odds decrease with clumping of the resource.")
                        RandTwo = 3 + dice.get(NearResources, "Odds decrease with clumping of resources.")

                        if (RandOne >= NearResource and RandTwo >= NearResources):
                                Plot = cymap.plotByIndex(I)
                                Plot.setBonusType(Resource)
                                added += 1
                                ResourceLocations.append(I)
                                NearLocations.append(I)

                                # Ensure no illegal clumping of the resource takes place.

                                if not ResourceClumps[Resource]:
                                        for i in PreventResourceClumping:
                                                Inew = GetNewTileIndex(I, i)
                                                if Inew == -1:
                                                        continue
                                                if Inew in EligibleTiles[Resource]:
                                                        EligibleTiles[Resource].remove(Inew)

	return 0

#--------------------------------------------------------------------------------------------------------------------------#
# Step 2: Add additional menu options.
#--------------------------------------------------------------------------------------------------------------------------#

selection_titles = [unicode("Resource Land Masses:"),
                    unicode("How Many Land Masses:"),
                    unicode("Resource Tiles:"),
                    unicode("Strategic Supply:"),
                    unicode("Health Supply:"),
                    unicode("Luxury Supply:"),
                    unicode("Let Resources Clump:"),
                    ]

selection_names_and_values = [
        [
                ["Standard", 0],
                ["LandMasses", 1],
                ["LandMasses, isolate horses", 2],
                ["No isolated resources", 3],
                ["Random", -1],
                ["Custom", 4],
                ],
        [
                ["Assigned to 1 land mass", 1],
                ["Assigned to 2 land masses", 2],
                ["Assigned to 3 land masses", 3],
                ["Assigned to 4 land masses", 4],
                ["Assigned to 5 land masses", 5],
                ["Assigned to 6 land masses", 6],
                ["Assigned to 7 land masses", 7],
                ["Assigned to 8 land masses", 8],
                ["Random", 0],
                ["Assigned to half the land masses", -1],
                ["Assigned to all but 1 land mass", -2],
                ["Custom", -3],
                ],
        [
                ["Standard", 0],
                ["LandMasses", 1],
                ["Crazy", 2],
                ["Custom", 3],
                ],
        [
                ["Few strategic resources", -1],
                ["Normal strategic resources", -2],
                ["Many strategic resources", -3],
                ["Random", 0],
                ["1 of each per civilization", -4],
                ["Custom", -5],
                ],
        [
                ["Few health resources", -1],
                ["Normal health resources", -2],
                ["Many health resources", -3],
                ["Random", 0],
                ["1 of each per civilization", -4],
                ["Custom", -5],
                ],
        [
                ["Few luxury resources", -1],
                ["Normal luxury resources", -2],
                ["Many luxury resources", -3],
                ["Random", 0],
                ["1 of each per civilization", -4],
                ["Custom", -5],
                ],
        [
                ["Standard", [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]],
                ["None", [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]],
                ["Strategic", [1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]],
                ["Health", [0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]],
                ["Luxury", [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]],
                ["Strategic/Health", [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]],
                ["Strategic/Luxury", [1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]],
                ["Health/Luxury", [0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]],
                ["Strategic/Health/Luxury", [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]],
                ["Custom", CustomiseResourceClumps()],
                ],
        ]

#--------------------------------------------------------------------------------------------------------------------------#
# Step 3: Further functions.
#--------------------------------------------------------------------------------------------------------------------------#

def isSeaLevelMap():
        return 0

def isRandomCustomMapOption(argsList):
        return False

def getDescription():
	return unicode("LandMasses Bonuses")

def getNumCustomMapOptions():
	return len(selection_titles)

def getCustomMapOptionName(argsList):
	return selection_titles[argsList[0]]

def getSelectedMapValue(OptionName):
        
	gc = CyGlobalContext()
	cymap = CyMap()
	dice = gc.getGame().getMapRand()
	
	for Option in range(len(selection_titles)):
		if selection_titles[Option] == OptionName:
                        break
	
	Choice = int(cymap.getCustomMapOption(Option))
	
	if Choice >= len(selection_names_and_values[Option]):
		Choice = 0
				
	cachedMenuChoices[Option] = Choice
	
	return selection_names_and_values[Option][Choice][1]

def getNumCustomMapOptionValues(argsList):
        return len(selection_names_and_values[argsList[0]])

def getCustomMapOptionDescAt(argsList):
	return unicode(selection_names_and_values[argsList[0]][argsList[1]][0])

# Save selected map options.

def saveSettings():
        
        global isamodule

        if isamodule == True:
                return
    
	cymap = CyMap()
	settings = open('LandMasses Bonuses.cfg', 'w')
	SavedSettings = []
	for Option in range(len(selection_titles)):
		Choice = int(cymap.getCustomMapOption(Option))
		ChoiceName = selection_names_and_values[Option][Choice][0]
		SavedSettings.append((selection_titles[Option], ChoiceName))
		
	print SavedSettings
	try:
		pickle.dump(SavedSettings, settings)
	except Exception, inst:
		print "    Pickling Error trying to save smartmap settings to LandMasses Bonuses.cfg", inst
	settings.close()

# Find previously selected map options.

def getCustomMapOptionDefault(argsList):
	result = 0
	try:
		settings = open('LandMasses Bonuses.cfg', 'r')
		SavedSettings = pickle.load(settings)
		for EachOption in range(len(SavedSettings)):
			Option, ChoiceName = SavedSettings[argsList[0]]
			if Option == selection_titles[argsList[0]]:
				for EachChoice in range(len(selection_names_and_values[argsList[0]])):
					EachChoiceName, EachChoiceValue = selection_names_and_values[argsList[0]][EachChoice]
					if EachChoiceName == ChoiceName:
						result = EachChoice
		settings.close()
	except IOError:
		print "    Couldn't find LandMasses Bonuses.cfg"
	except EOFError:
		print "    Bad contents in LandMasses Bonuses.cfg"
		
	return result

def isAdvancedMap():
	return 1

def beforeInit():
	global cachedMenuChoices
	cachedMenuChoices = []
	for Choice in range(len(selection_names_and_values)):
		cachedMenuChoices.append((0))
		
def beforeGeneration():
	global cachedMenuChoices
	for Choice in range(len(selection_names_and_values)):
		if selection_names_and_values[Choice][0] != "Wrap:":
			cachedMenuChoices[Choice] = 0

def GetNewTileIndex(I, direction):
	
	global width
	global Area

	dx, dy = direction
	Inew = I + dx + (width*dy)

	if Inew < 0 or Inew >= Area:
		Inew = -1

	return (Inew)

def GetLandMasses():

        global Area

        cymap = CyMap()
	
	LandMassTiles = []
	LandMasses = []
	LandMassNumber = -1

	# Determine which tiles land masses and coasts are comprised of.

        for I in range(Area):

                Plot = cymap.plotByIndex(I)
                Terrain = Plot.getTerrainType()

                if Terrain == 6:
                        continue

                LandMassTiles.append(I)

        while len(LandMassTiles) > 0:

                # Pick the first tile of a landmass.

                LandMasses.append([])
                LandMassNumber += 1
                I = LandMassTiles[0]
                LandMassTiles.remove(I)
                LandMasses[LandMassNumber].append(I)
                AdjacentLandMassTiles = []

                # Next, collect its neighbours that also form the land mass.

                for i in cardinalDirs:

                        Inew = GetNewTileIndex(I, i)
                        if Inew == -1:
                                continue
                        Plotnew = cymap.plotByIndex(Inew)
                        Terrainnew = Plotnew.getTerrainType()

                        if Terrainnew == 6:
                                continue

                        AdjacentLandMassTiles.append(Inew)

                # Collect all tiles which form the land mass.

                while len(AdjacentLandMassTiles) > 0:
                        Inew = AdjacentLandMassTiles[0]
                        AdjacentLandMassTiles.remove(Inew)
                        LandMassTiles.remove(Inew)
                        LandMasses[LandMassNumber].append(Inew)

                        for i in cardinalDirs:

                                Inext = GetNewTileIndex(Inew, i)
                                if Inext == -1:
                                        continue

                                if Inext in LandMasses[LandMassNumber] or Inext in AdjacentLandMassTiles:
                                        continue
                                
                                Plotnext = cymap.plotByIndex(Inext)
                                Terrainnext = Plotnext.getTerrainType()

                                if Terrainnext == 6:
                                        continue

                                AdjacentLandMassTiles.append(Inext)

        return LandMasses

#--------------------------------------------------------------------------------------------------------------------------#
# Build Notes.
#--------------------------------------------------------------------------------------------------------------------------#

# Version 1.0:
# Seems to work as intended.
